package coreservlets;

import java.math.BigInteger;

/** Kilka narzdzi pomocniczych do generowania duej
 *  losowej liczby BigInteger i wyznaczenia wikszej od niej,
 *  najbliszej jej liczby pierwszej.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class Primes {

  private static final BigInteger ZERO = BigInteger.ZERO;
  private static final BigInteger ONE = BigInteger.ONE;
  private static final BigInteger TWO = new BigInteger("2");

  // Prawdpodobiestwo wyznaczenia bdnej liczby pierwszej
  // jest mniejsze ni 1/2^ERR_VAL.
  // Z zaoenia BigInteger uywa testu Millera-Rabina
  // lub jego odpowiednika, dziki czemu NIE wystpuj
  // zakcenia liczbami Carmichaela.
  // Wicej szczegowych informacji znajduje si w punkcie 33.8 
  // ksiki Cormena i innych pt. Introduction to Algorithms.
  private static final int ERR_VAL = 100;

  public static BigInteger nextPrime(BigInteger start) {
    if (isEven(start))
      start = start.add(ONE);
    else
      start = start.add(TWO);
    if (start.isProbablePrime(ERR_VAL))
      return(start);
    else
      return(nextPrime(start));
  }

  private static boolean isEven(BigInteger n) {
    return(n.mod(TWO).equals(ZERO));
  }

  private static StringBuffer[] digits =
    { new StringBuffer("0"), new StringBuffer("1"),
      new StringBuffer("2"), new StringBuffer("3"),
      new StringBuffer("4"), new StringBuffer("5"),
      new StringBuffer("6"), new StringBuffer("7"),
      new StringBuffer("8"), new StringBuffer("9") };

  private static StringBuffer randomDigit(boolean isZeroOK) {
    int index;
    if (isZeroOK) {
      index = (int)Math.floor(Math.random() * 10);
    } else {
      index = 1 + (int)Math.floor(Math.random() * 9);
    }
    return(digits[index]);
  }

  /** Utworzenie duej, losowej liczby cakowitej, w ktrej
   *  kada cyfra jest wybierana losowo (z wyjtkiem pierwszej,
   *  ktra nie moe by zerem).
   */

  public static BigInteger random(int numDigits) {
    StringBuffer s = new StringBuffer("");
    for(int i=0; i<numDigits; i++) {
      if (i == 0) {
        // Pierwsz cyfr nie moe by zero.
        s.append(randomDigit(false));
      } else {
        s.append(randomDigit(true));
      }
    }
    return(new BigInteger(s.toString()));
  }

  /** Program testowy dziaajcy w wierszu polece.
   *  Wystarczy wpisa liczb cyfr, a program wygeneruje 
   *  losow liczb o wskazanej dugoci i zwrci pierwszych 
   *  pidziesit liczb pierwszych, ktre s od niej wiksze.
   */

  public static void main(String[] args) {
    int numDigits;
    try {
      numDigits = Integer.parseInt(args[0]);
    } catch (Exception e) { // Brak argumentw lub argumenty nieprawidowe.
      numDigits = 150;
    }
    BigInteger start = random(numDigits);
    for(int i=0; i<50; i++) {
      start = nextPrime(start);
      System.out.println("Liczba pierwsza " + i + " = " + start);
    }
  }
}
